/* SSIheader.h */
#ifndef _SSIHEADER_H_
#define _SSIHEADER_H_

#define SSI_UNKNOWN_COMMAND -101
#define SSICTRL_DATAFORMATERR -102
#define SSICTRL_PARAMFORMAT_ERR -103
#define IMAGE_TYPE_UNKNOWN -104

/* these are the input parameters to the SendCommand() Method */
enum
{
 ssiTurnAimOn = 0,
 ssiTurnAimOff = 1,
 ssiTurnLedOn = 2,
 ssiTurnLedOff = 3,
 ssiEnableScanner = 4,
 ssiDisableScanner = 5,
 ssiSendBeep = 6,
 ssiSWTriggerPull = 7,
 ssiSWTriggerRelease = 8,
 ssiAbortImage = 9,
 ssiTakePicture = 10,
 ssiStartVideoStream = 11,
 ssiRequestCapabilities = 12,
 ssiRequestAllParameters = 13,
 ssiRequestVersionData = 14,
 ssiTerminateMacroPDF = 15,  
 ssiEnterLowPowerMode = 16,  
} ;



/* These ar defines that can be used when getting parameter values and changing parameter values 
** when using the VS4000 imager 
*/

/* Some parameter numbers have allowable values of either enabled or disabled.
** Others have multiple settings for their allowable values
** This group of parameter numbers have values of enabled or disabled only
*/

#define ENABLED_VALUE 1
#define DISABLED_VALUE 0

/* Some parameter numbers have allowable values of either enabled or disabled.
** Others have multiple settings for their allowable values
** This group of parameter numbers have values of enabled or disabled only
** Note parameter numbers are long values, parameter values are short values for purposes of the ssi control
*/

#define PARAMETER_SCANNING_PARAM       0x000000EC  /* when using ssi you should disable this parameter */
#define BEEP_AFTER_GOOD_DECODE_PARAM   0x00000038 
#define DECODING_AUTOEXPOSURE_PARAM    0x0000F029  /* these next 3 are examples of extended paramter numbers */
#define DECODING_ILUMINATION_PARAM     0x0000F02A  
#define IMAGE_CAP_AUTOEXPOSURE_PARAM   0x0000F069
#define IMAGE_CAP_ILLUMINATION_PARAM   0x0000F068


#define UPCA_CODETYPE_PARAM            0x00000001
#define UPCE_CODETYPE_PARAM            0x00000002
#define UPCE1_CODETYPE_PARAM           0x0000000C
#define EAN8_CODETYPE_PARAM            0x00000004
#define EAN13_CODETYPE_PARAM           0x00000003
#define BOOKLANDEAN_CODETYPE_PARAM     0x00000053
#define CODE39_CODETYPE_PARAM          0x00000000
#define CODE39FULLASCII_CODETYPE_PARAM 0x00000011
#define TRIOPTICCODE39_CODETYPE_PARAM  0x0000000D
#define CODE93_CODETYPE_PARAM          0x00000009
#define COD128_CODETYPE_PARAM          0x00000008
#define UCC128_CODETYPE_PARAM          0x0000000E
#define ISBT128_CODETYPE_PARAM         0x00000054
#define CODABAR_CODETYPE_PARAM         0x00000007

#define I2OF5_CODETYPE_PARAM           0x00000006
#define D2OF5_CODETYPE_PARAM           0x00000005
#define MSIPLESSEY_CODETYPE_PARAM      0x0000000B
#define USPOSTNET_CODETYPE_PARAM       0x00000059
#define USPLANET_CODETYPE_PARAM        0x0000005A
#define UKPOSTAL_CODETYPE_PARAM        0x0000005B
#define JAPANPOSTAL_CODETYPE_PARAM     0x0000F022
#define AUSTRALIANPOST_CODETYPE_PARAM  0x0000F023
#define PDF417_CODETYPE_PARAM          0x0000000F
#define MICROPDF417_CODETYPE_PARAM     0x000000E3
#define DATAMATRIX_CODETYPE_PARAM      0x0000F024
#define MAXICODE_CODETYPE_PARAM        0x0000F026
#define QRCODE_CODETYPE_PARAM          0x0000F025



/** These parameters have multiple settings for their allowable values ***/



/* 
**
** The first pam numbers and allowable values as shown as examples of different parameter types
** Non-extended paramnum with byte values
** Extended paramnum with a word value
** Extended paramnum with a byte value
*/

/* this is not an extended paramnum and has a byte value */
#define BEEPER_VOLUME_PARAMNUM 0x0000008C  

/* beeper volume values may be one of these */
#define BEEPER_HI_VOLUME 0x00000009
#define BEEPER_MEDIUM_VOLUME 0x00000003
#define BEEPER_LO_VOLUME 0x00000000


/* this is an extended paramnum and has a word value */
#define IMAGER_GAIN_PARAMNUM   0x00f4f037  

/* this is an extended paramnum and has a byte value */
#define IMAGE_CAPTURE_ILLUMINATION_PARAMNUM 0x0000f069

/* so does this one */
#define SSIIMAGE_FORMAT_PARAM 0x0000f030
/* and it has values of ...*/
#define SSIBITMAP_FORMAT	0x03
#define SSITIFF_FORMAT		0x04
#define SSIJPEG_FORMAT		0x01


/* USE this parameter number with this value to put the unit into Host Trigger Mode 
** This is NOT USED for the VS4000.
*/
#define TRIGGER_MODE_PARAM			0x0000008A
#define HOST_TRIGGER_MODE_VALUE	8


/* Add other parameter numbers and allowable values here as desired */

#endif